#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <pthread.h>

#define BROJ_VOZILA 10
#define SMER_LEVI 0
#define SMER_DESNI 0

#define AUTO 0
#define AUTOBUS 1
#define KAMION 2

int brojVozila[3] = {0,0,0};

int smerovi[2] = {0,0};

pthread_cond_t cond;
pthread_mutex_t mu;

int canCross(int tipVozila, int smer) {
    if(smerovi[(smer + 1) % 2] > 0 || brojVozila[KAMION] > 0) {
        return 0;
    }

    if(tipVozila == KAMION && (brojVozila[AUTOBUS] > 0  || brojVozila[AUTO] > 0)) {
        return 0;
    }

    if(tipVozila == AUTOBUS && brojVozila[AUTOBUS] > 0 ) {
        return 0;
    }

    return 1;
}

void stampajTip(int tipVozila) {
    if(tipVozila == KAMION) {
        printf("KAMION");
    } else if (tipVozila == AUTO) {
        printf("AUTO");
    } else {
        printf("AUTOBUS");
    }
}

void stampajStanje() {
    printf(" BROJ KAMIONA: %d | BROJ AUTOMOBILA: %d | BROJ AUTOBUSA: %d\n", brojVozila[KAMION], brojVozila[AUTO], brojVozila[AUTOBUS]);
}

void* predjiNadvoznjak(void* i) {
    long idx = (long)i;
    int cekaj = rand() % 20;
    int smer = rand() % 2;
    int tipVozila = rand() % 3;
    sleep(cekaj);
    pthread_mutex_lock(&mu);
    stampajTip(tipVozila);
    printf(" sa id: %ld dolazi na most\n", idx);
    while(!canCross(tipVozila, smer)) {
        stampajTip(tipVozila);
        printf(" sa id: %ld ceka za prelazak mosta\n", idx);
        pthread_cond_wait(&cond, &mu);
    }
    smerovi[smer]++;
    brojVozila[tipVozila]++;
    pthread_mutex_unlock(&mu);
    stampajTip(tipVozila);
    printf(" sa id: %ld prelazi most | ", idx);
    stampajStanje();

    sleep(2);
    pthread_mutex_lock(&mu);
    pthread_cond_broadcast(&cond);
    brojVozila[tipVozila]--;
    smerovi[smer]--;
    pthread_mutex_unlock(&mu);
    stampajTip(tipVozila);
    printf(" sa id: %ld je presao most\n", idx);
}

int main() {
    pthread_mutex_init(&mu, NULL);
    pthread_cond_init(&cond, NULL);

    pthread_t vozila[BROJ_VOZILA];

    for(long i=0;i<BROJ_VOZILA;i++) {
        pthread_create(vozila + i, NULL, predjiNadvoznjak, (void*)i);
    }

    for(long i=0;i<BROJ_VOZILA;i++) {
        pthread_join(vozila[i],NULL);
    }

    pthread_mutex_destroy(&mu);
    pthread_cond_destroy(&cond);

    return 0;
}